/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.snmp;

import java.util.StringTokenizer;

public class Oid
implements Comparable {
    private long[] elements;
    private String oidString;

    private Oid() {
    }

    public Oid(String s) {
        this.oidString = s;
        StringTokenizer st = new StringTokenizer(s, ".");
        this.elements = new long[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            this.elements[i++] = Long.parseLong(st.nextToken());
        }
    }

    public int numElements() {
        return this.elements.length;
    }

    public Oid extractSubOid(int start, int len) {
        Oid newOid = new Oid();
        newOid.elements = new long[len];
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < len) {
            newOid.elements[i] = this.elements[start + i];
            sb.append(this.elements[start + i]);
            if (i + 1 < len) {
                sb.append(".");
            }
            ++i;
        }
        newOid.oidString = sb.toString();
        return newOid;
    }

    public int compareTo(Object o) {
        long[] oid2 = ((Oid)o).elements;
        int i = 0;
        do {
            if (this.elements[i] == oid2[i]) continue;
            long ret = this.elements[i] - oid2[i];
            if (ret == 0L) {
                return 0;
            }
            if (ret > 0L) {
                return 1;
            }
            return -1;
        } while (++i < this.elements.length && i < oid2.length);
        return this.elements.length - oid2.length;
    }

    public boolean equals(Object o) {
        long[] oid2 = ((Oid)o).elements;
        if (this.elements.length != oid2.length) {
            return false;
        }
        int i = 0;
        while (i < this.elements.length) {
            if (this.elements[i] != oid2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return this.oidString;
    }
}

